package Flyweight;

public class DocumentEditor {
    private CharacterFactory characterFactory;

    public DocumentEditor(CharacterFactory characterFactory) {
        this.characterFactory = characterFactory;
    }

    public void insertCharacter(char character, String font, int size, String color) {
        CustomCharacter formattedCharacter = characterFactory.getFormattedCharacter(character);
        formattedCharacter.display(font, size, color);
    }

    public static void main(String[] args) {
        CharacterFactory characterFactory = new CharacterFactory();
        DocumentEditor documentEditor = new DocumentEditor(characterFactory);

        // Aggiunta di caratteri formattati al documento
        documentEditor.insertCharacter('H', "Arial", 12, "Blue");
        documentEditor.insertCharacter('e', "Times New Roman", 14, "Red");
        documentEditor.insertCharacter('l', "Courier New", 16, "Green");
        documentEditor.insertCharacter('l', "Arial", 12, "Black");
        documentEditor.insertCharacter('o', "Calibri", 18, "Purple");
    }
}